/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.opengl;

public class BlurShaderUtils {
    public static final String UNIFORM_TEXTURE = "texture";
    public static final String UNIFORM_LIGHT = "light";
    private static final String VARYING_COORD = "texCoord";
    private static final String VALUE_LIGHT = "light";

    public static final float[] createLinearKernel(int n) {
        return BlurShaderUtils.createLinearKernel(n, 1.0f);
    }

    public static final float[] createLinearKernel(int n, float f) {
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = (float)n2 * f + 1.0f;
            ++n2;
        }
        return fArray;
    }

    public static final float[] createParabolicKernel(int n) {
        return BlurShaderUtils.createParabolicKernel(n, 1.0f);
    }

    public static final float[] createParabolicKernel(int n, float f) {
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            float f2 = (float)n2 * f + 1.0f;
            fArray[n2] = f2 * f2;
            ++n2;
        }
        return fArray;
    }

    public static final float[] createSquareRootKernel(int n) {
        return BlurShaderUtils.createSquareRootKernel(n, 1.0f);
    }

    public static final float[] createSquareRootKernel(int n, float f) {
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = (float)Math.sqrt(f * (float)n2 + 1.0f);
            ++n2;
        }
        return fArray;
    }

    public static final float[] createGaussianKernel(int n) {
        return BlurShaderUtils.createGaussianKernel(n, 1.0);
    }

    public static final float[] createGaussianKernel(int n, double d) {
        float[] fArray = new float[n];
        double d2 = 1.0 / (d * Math.sqrt(Math.PI * 2));
        double d3 = 1.0;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n - n2 - 1;
            double d4 = (double)(-n3 * n3) / (2.0 * d * d);
            double d5 = Math.exp(d4);
            double d6 = d2 * d5;
            if (n2 == 0) {
                d3 = 1.0 / d6;
            }
            fArray[n2] = (float)(d6 * d3);
            ++n2;
        }
        return fArray;
    }

    public static final StringBuilder generateVerticalFragmentShader(float f, Float f2, float[] fArray, boolean bl) {
        return BlurShaderUtils.generateFragmentShader(f, f2, fArray, bl, true);
    }

    public static final StringBuilder generateHorizontalFragmentShader(float f, Float f2, float[] fArray, boolean bl) {
        return BlurShaderUtils.generateFragmentShader(f, f2, fArray, bl, false);
    }

    public static final StringBuilder generateVertexShader(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(1000);
        String string = System.getProperty("line.separator");
        String string2 = bl ? "\t" : "";
        stringBuilder.append("varying vec2 ").append(VARYING_COORD).append(';').append(string);
        if (bl) {
            stringBuilder.append(string);
        }
        stringBuilder.append("void main(void)").append(bl ? string : " ");
        stringBuilder.append("{").append(string);
        stringBuilder.append(string2).append("gl_Position = ftransform();").append(string);
        if (bl) {
            stringBuilder.append(string);
            stringBuilder.append(string2).append("// Clean up inaccuracies").append(string);
        }
        stringBuilder.append(string2).append("vec2 pos = sign(gl_Vertex.xy);").append(string);
        stringBuilder.append(string2).append("gl_Position = vec4(pos, 0.0, 1.0);").append(string);
        if (bl) {
            stringBuilder.append(string);
            stringBuilder.append(string2).append("// Convert to image-space").append(string);
        }
        stringBuilder.append(string2).append(VARYING_COORD).append(" = pos * 0.5 + 0.5;").append(string);
        stringBuilder.append('}').append(string);
        return stringBuilder;
    }

    private static final StringBuilder generateFragmentShader(float f, Float f2, float[] fArray, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(2000);
        String string = System.getProperty("line.separator");
        String string2 = bl ? "\t" : "";
        int n = fArray.length - 1;
        float[] fArray2 = new float[2 * n + 1];
        float f3 = 0.0f;
        int n2 = fArray.length;
        while (n2-- > 0) {
            float f4;
            fArray2[2 * n - n2] = f4 = fArray[n2];
            fArray2[n2] = f4;
            f3 += f4 + f4;
        }
        f3 -= fArray2[n];
        stringBuilder.append("uniform sampler2D ").append(UNIFORM_TEXTURE).append(';').append(string);
        if (f2 == null) {
            stringBuilder.append("uniform float ").append("light").append(';').append(string);
        }
        if (bl) {
            stringBuilder.append(string);
        }
        stringBuilder.append("varying vec2 ").append(VARYING_COORD).append(';').append(string);
        if (bl) {
            stringBuilder.append(string);
        }
        stringBuilder.append("const float step  = 1.0/").append(f).append(';').append(string);
        stringBuilder.append("const float total = ").append(f3).append(';').append(string);
        if (f2 != null && f2.floatValue() != 1.0f) {
            stringBuilder.append("const float ").append("light").append(" = ").append(f2).append(';').append(string);
        }
        if (bl) {
            stringBuilder.append(string);
        }
        stringBuilder.append("void main(void)").append(bl ? string : " ");
        stringBuilder.append("{").append(string);
        stringBuilder.append(string2).append("float").append(bl ? string : " ");
        n2 = 0;
        while (n2 < fArray2.length) {
            stringBuilder.append(string2).append(n2 == 0 ? "sum  = (" : "sum += (");
            if (f2 != null && f2.floatValue() != 1.0f) {
                stringBuilder.append("light").append(" * ");
            }
            stringBuilder.append(fArray2[n2]);
            stringBuilder.append(" / total) * texture2D( ").append(UNIFORM_TEXTURE).append(", vec2(").append(VARYING_COORD).append(".x");
            if (bl2) {
                stringBuilder.append(", ").append(VARYING_COORD).append(".y");
            }
            if (n2 < n) {
                stringBuilder.append(" - ");
                if (n2 < n - 1) {
                    stringBuilder.append(n - n2).append(".0*");
                }
                stringBuilder.append("step");
            } else if (n2 > n) {
                stringBuilder.append(" + ");
                if (n2 > n + 1) {
                    stringBuilder.append(n2 - n).append(".0*");
                }
                stringBuilder.append("step");
            }
            if (!bl2) {
                stringBuilder.append(", ").append(VARYING_COORD).append(".y");
            }
            stringBuilder.append(")).r;").append(string);
            ++n2;
        }
        if (bl) {
            stringBuilder.append(string);
        }
        stringBuilder.append(string2).append("gl_FragColor = vec4( vec3(sum");
        if (f2 == null) {
            stringBuilder.append(" * ").append("light");
        }
        stringBuilder.append("), 1);").append(string);
        stringBuilder.append('}').append(string);
        return stringBuilder;
    }
}

